import pandas as pd
import glob

# Get all sales files like sales_Jan.xlsx, sales_Feb.xlsx
all_files = glob.glob("sales_*.xlsx")
summary_list = []

for file in all_files:
    df = pd.read_excel(file)
    total_qty = df["Quantity"].sum()
    month = file.split("_")[1].split(".")[0]
    summary_list.append({"Month": month, "TotalQuantity": total_qty})

# Create combined summary
summary_df = pd.DataFrame(summary_list)
summary_df.to_excel("annual_summary.xlsx", index=False)