def excel_formula_automation():
    """Automate complex Excel formulas"""
    wb = Workbook()
    ws = wb.active
    
    # Create sample data
    data = [
        ["Product", "Price", "Quantity", "Total"],
        ["A", 19.99, 5],
        ["B", 29.99, 3],
        ["C", 9.99, 10]
    ]
    
    for row in data:
        ws.append(row)
    
    # Add formulas
    for i in range(2, 5):
        ws[f'D{i}'] = f"=B{i}*C{i}"  # Total = Price * Quantity
    
    # Add summary formulas
    ws['B6'] = "Subtotal:"
    ws['C6'] = "=SUM(D2:D4)"
    ws['B7'] = "Tax (10%):"
    ws['C7'] = "=C6*0.1"
    ws['B8'] = "Total:"
    ws['C8'] = "=C6+C7"
    
    # Format cells
    for cell in ['B6', 'B7', 'B8']:
        ws[cell].font = Font(bold=True)
    
    wb.save("formula_demo.xlsx")
    print("Created Excel file with automated formulas")

excel_formula_automation()