def modify_excel(file_path):
    """Modify specific cells in Excel"""
    wb = load_workbook(file_path)
    ws = wb.active
    
    # Update cell values
    ws['B2'] = 29  # Update Alice's age
    ws['C3'] = "IT"  # Update Bob's department
    
    # Add formula
    ws['D1'] = "Bonus"
    ws['D2'] = "=B2*100"  # Age * 100
    ws['D3'] = "=B3*100"
    
    # Format cells
    from openpyxl.styles import Font, Color
    ws['A1'].font = Font(bold=True, color="FF0000")
    
    wb.save(file_path)
    print(f"Modified file saved: {file_path}")

modify_excel("sample_data.xlsx")