# read_pdf_text.py

# Import the PdfReader class from the PyPDF2 library
from PyPDF2 import PdfReader

def read_pdf_text(pdf_path):
    """
    Extract text from all pages of a PDF file.
    
    Args:
        pdf_path (str): Path to the PDF file
    
    Prints:
        First 500 characters of the extracted text
    """
    
    # Open the PDF file in read-binary mode
    with open(pdf_path, 'rb') as file:
        reader = PdfReader(file)  # Create a PDF reader object
        text = ""  # Store extracted text here

        # Loop through each page in the PDF
        for page in reader.pages:
            text += page.extract_text() + "\n\n"  # Add page text with spacing

        # Print a preview of the extracted text
        print(f"Extracted text from {pdf_path}:\n")
        print(text[:500] + "...")  # Print only the first 500 characters

# Example usage
read_pdf_text("sample.pdf")
